# MultiChat WHMCS Integration Module

## Installation Instructions

### Step 1: Upload Files
The module files are already in place at:
```
/modules/addons/multichat/
├── multichat.php (main module file)
├── hooks.php (automation hooks)
├── templates/
│   └── clientarea.tpl (client area template)
└── README.md (this file)
```

### Step 2: Generate MultiChat API Key
1. Log into your MultiChat admin panel at: https://multichat.website/members/
2. Navigate to: https://multichat.website/members/settings.php
3. Look for the API key at the bottom of the settings page. 

### Step 3: Activate the Module
1. Log into WHMCS Admin Area
2. Go to: **Setup → Addon Modules**
3. Find "MultiChat Integration" in the list
4. Click **Activate**
5. Configure Access Control (which admin roles can manage the module)

### Step 4: Configure Module Settings
After activation, click **Configure** and enter:

- **MultiChat API URL**: https://multichat.website (your MultiChat installation URL)
- **API Key**: [Paste the API key from Step 2]
- **Chat Bubble Key**: [Get this from MultiChat chat bubbles section]
- **Enable Client Portal Widget**: Yes/No (show chat in client area)
- **Auto-Link Customers**: Yes/No (automatically sync new clients)
- **Show in Admin Dashboard**: Yes/No (quick access link)

### Step 5: Test the Connection
1. In WHMCS, go to: **Addons → MultiChat Integration**
2. Click **Test Connection** button
3. You should see: "Connection successful! MultiChat API is working properly."

### Step 6: Sync Existing Customers
1. Click **Sync All Customers** button
2. This will link all your active WHMCS clients to MultiChat
3. Wait for completion message

 
## Features

### Admin Features
- **Dashboard**: View statistics and sync status
- **Quick Access**: Direct link to MultiChat dashboard

### Client Features
- **Chat Widget**: Embedded in client area
- **Pre-filled Info**: Name and email automatically populated
- **Seamless Integration**: Looks native to WHMCS theme
- **24/7 Access**: Always available support channel

### Automation (Hooks)
- **ClientAdd**: Auto-sync new clients when they register
- **ClientEdit**: Update MultiChat when client details change
- **ClientLogin**: Ensure sync when client logs in
- **Widget Injection**: Auto-inject chat widget in client area footer

## Using the Chat Widget

### In Client Area
Clients can access live chat at:
```
https://your-whmcs-site.com/index.php?m=multichat
```

Or the widget auto-loads in the footer of all client area pages (if enabled).
 